<?php
/**
 * @ H2N Link Directory 1.0.0 linkdirectory.captcha.php
 * @ Copyright (C) 2008 Harry Klein - joomla.neschke.eu
 * @
 * @ All rights reserved
 * @ Link Directory Component is Free Software
 * @ Released under GNU/GPL License : http://www.gnu.org/copyleft/gpl.html
 * @
 * @ $Id: linkdirectory.captcha.php,v 1.6 2008/05/23 21:59:18 harry Exp $
 * @
 **/

defined( '_VALID_MOS' ) or die( 'Restricted access' );

function validateCaptcha (){
	global $ld,$my;
	
	if (!isCaptchaEnable()) return true;
	
	$checkSecurity = false;
	switch($ld->securityimage) {
		case 'easycaptcha':
			$captcha_id = strval( mosGetParam( $_POST, 'captcha_id', '' ) );
			$captcha_code = strval( mosGetParam( $_POST, 'captcha_code', '' ) );
			$captcha = new EasyCaptcha($captcha_id);
			$checkSecurity = $captcha->checkEnteredCode($captcha_code);
			break;
		case 'securityimages':
			if ($ld->securityimage4){
				$securityimage_newpass_refid = mosGetParam( $_POST, 'securityimage_newpass_refid','');
				$securityimage_newpass_try = mosGetParam( $_POST, 'securityimage_newpass_try','');
				$securityimage_newpass_reload = mosGetParam( $_POST, 'securityimage_newpass_reload','');
				$checkSecurity = checkSecurityImage($securityimage_newpass_refid, $securityimage_newpass_try,
				$securityimage_newpass_reload);
			}
			else {
				$security_refid = mosGetParam($_POST, "security_refid", $security_refid);
				$security_try = mosGetParam($_POST, "security_try", $security_try);
				$checkSecurity = checkSecurityImage($security_refid, $security_try);
			}
			break;
		default:
			$checkSecurity = true;
	}
	return $checkSecurity;
}

function isCaptchaEnable(){
	global $ld,$my;
	$return = false;
	switch($ld->securityimage) {
		case 'easycaptcha':
			if (file_exists(_LD_ABSOLUTE_PATH.'/components/com_easycaptcha/class.easycaptcha.php')) {
      			include_once(_LD_ABSOLUTE_PATH.'/components/com_easycaptcha/class.easycaptcha.php');
      			if(class_exists("EasyCaptcha") AND !$my->gid) {
					$return = true;
      			}
			}
			break;
		case 'securityimages':
			if (file_exists(_LD_ABSOLUTE_PATH.'/administrator/components/com_securityimages/config.securityimages.php')){
				require (_LD_ABSOLUTE_PATH.'/administrator/components/com_securityimages/config.securityimages.php');
				include_once (_LD_ABSOLUTE_PATH."/administrator/components/com_securityimages/server.php");
				require (_LD_ABSOLUTE_PATH.'/administrator/components/com_securityimages/client.php');
				if (!$securitySwitchOffGlobally AND !$my->gid){
					$return = true;
				}	
			}
			break;
	}
	return $return;
}

function displayCaptcha (){
	global $ld,$my;
	$html='';
	switch($ld->securityimage) {
		case 'easycaptcha':
			$captcha = new easyCaptcha();
			if($captcha->captcha_id) {
				$html.='<input type="hidden" name="captcha_id" value="';
				$html.=$captcha->getCaptchaId() . '" />';
				$html.='<img src="';
				$html.=$captcha->getImageUrl();
				$html.=' alt="'.$captcha->getAltText();
				$html.='" id="code" />'.$captcha->getReloadButton("code").$captcha->getReloadCode();
				$html.='<br />';
				$html.='<br />';
				$html.='<input type="text" name="captcha_code" id="contact_captcha" class="inputbox" />';
			}
			break;
		case 'securityimages':
			if ($ld->securityimage4){ 
				$packageName = 'securityimage_newpass';
				$html.=insertSecurityImage($packageName);
				$html.='<br />';
				$html.=getSecurityImageField($packageName);
			} else {
				$html.=insertSecurityImage("security_refid");
				$html.='<br>';
				$html.=getSecurityImageText("security_try");
			}
			break;
		default:
			$html='';
	}
	return $html;
}

?>