<?php
/**
 * @ H2N Link Directory 1.0.0 linkdirectory.categories.php
 * @ Copyright (C) 2008 Harry Klein - joomla.neschke.eu
 * @
 * @ Link Directory 1.1 linkdirectory.categories.php
 * @ Copyright (C) 2006 Soner (pisdoktor) Ekici - www.sonerekici.com
 * @ All rights reserved
 * @ Link Directory Component is Free Software
 * @ Released under GNU/GPL License : http://www.gnu.org/copyleft/gpl.html
 **/

defined( '_VALID_MOS' ) or die( 'Restricted access' );

//Default homepage of the component
function Categories($option, $Itemid) {
	global $database, $mainframe, $my, $ld, $temp;

	$query = "SELECT * FROM #__ldcats"
	. "\n WHERE published = 1"
	. "\n AND access <= $my->gid"
	. "\n AND parent_id = 0"
	. "\n ORDER BY $ld->catorder"
	;
	$database->setQuery($query);
	$rows = $database->loadObjectList();

	$mainframe->SetPageTitle( _LD_HOME );

	$temp->catid = null;
	$temp->rows = $rows;
	$temp->Itemid = $Itemid;
	$temp->column = $ld->column;
	$temp->catimage = $ld->catimage;
	$temp->tlink = $ld->tlink;
	$temp->catdesc = $ld->catdesc;
	$temp->option = $option;
	$temp->copyrigthinfo = $ld->copyrigthinfo;

	$temp->display('header.tpl.php');
	$temp->display('userpanel.tpl.php');
	$temp->display('categorylist.tpl.php');
	$temp->display('footer.tpl.php');
}

//View sub categories and links for selected category
function ViewCategory($catid, $option, $Itemid, $limitstart) {
	global $database, $my, $mainframe, $ld, $temp;

	$row = new snrCats($database);
	$row->load($catid);

	if (!$row->published) {
		mosNotAuth();
		return;
	}

	if ( $row->access > $my->gid ) {
		mosNotAuth();
		return;
	}

	//Get sub categories
	$query = "SELECT * FROM #__ldcats"
	. "\n WHERE published = 1"
	. "\n AND access <= $my->gid"
	. "\n AND parent_id = $catid"
	. "\n ORDER BY $ld->catorder"
	;

	$database->setQuery($query);
	$rows = $database->loadObjectList();

	//Get web links
	$database->setQuery("SELECT COUNT(*) FROM #__ldlinks"
	. "\n WHERE catid = $catid"
	. "\n AND published=1" );

	$totallink = $database->loadResult();

	//Page navigation
	require_once(  _LD_ABSOLUTE_PATH . '/includes/pageNavigation.php' );
	if (($totallink > $ld->limitlink) && ($ld->limitlink > 0)) {
		$pageNav = new mosPageNav( $totallink, $limitstart, $ld->limitlink );
	} else {
		$pageNav = NULL;
	}

	//Get web links in current page...
	$query = "SELECT * FROM #__ldlinks"
	. "\n WHERE catid = $catid"
	. "\n AND published=1"
	. "\n ORDER BY $ld->linkorder"
	. "\n LIMIT $limitstart, $ld->limitlink"
	;

	$database->setQuery( $query );
	$links = $database->loadObjectList();

	$tabclass = array( 'link1', 'link2' );

	if ($ld->dpage) {
		$mainframe->SetPageTitle( _LD_HOME .' - '. $row->title );
	} else {
		$mainframe->SetPageTitle( _LD_HOME );
	}

	$temp->catid = $catid;
	$temp->rows = $rows;
	$temp->Itemid = $Itemid;
	$temp->option = $option;
	$temp->links = $links;

	$temp->column = $ld->column;
	$temp->catimage = $ld->catimage;
	$temp->tlink = $ld->tlink;
	$temp->catdesc = $ld->catdesc;
	$temp->ratelink = $ld->ratelink;
	$temp->showfastlink = $ld->showfastlink;
	$temp->showhits = $ld->showhits;
	$temp->commentlink = $ld->commentlink;
	$temp->copyrigthinfo = $ld->copyrigthinfo;

	$temp->tabclass = $tabclass;
	$temp->limitstart = $limitstart;
	$temp->pageNav = $pageNav;


	$temp->display('header.tpl.php');
	$temp->display('userpanel.tpl.php');
	$temp->display('categorylist.tpl.php');
	$temp->display('linklists.tpl.php');
	$temp->display('footer.tpl.php');

}

//View sub categories in to the selected category
function SubCategories(&$catid) {
	global $database, $my, $ld, $temp, $Itemid;

	$query = "SELECT * FROM #__ldcats"
	. "\n WHERE parent_id = $catid"
	. "\n AND published = 1"
	. "\n AND access <= $my->gid"
	. "\n ORDER BY $ld->catorder"
	. "\n LIMIT 0,$ld->sublimit"
	;
	$database->setQuery($query);

	$subcats = $database->loadObjectList();

	$temp->subcat = $subcats;
	$temp->tslink = $ld->tslink;
	$tepm->Itemid = $Itemid;

	$temp->display('subcatnames.tpl.php');
}
?>
