<?php
/**
 * @ H2N Link Directory 1.0.0 linkdirectory.comments.php
 * @ Copyright (C) 2008 Harry Klein - joomla.neschke.eu
 * @
 * @ Link Directory 1.1 linkdirectory.comments.php
 * @ Copyright (C) 2006 Soner (pisdoktor) Ekici - www.sonerekici.com
 * @ All rights reserved
 * @ Link Directory Component is Free Software
 * @ Released under GNU/GPL License : http://www.gnu.org/copyleft/gpl.html
 **/

// no direct access
defined( '_VALID_MOS' ) or die( 'Restricted access' );

//Show comment page if settings are enabled
function CommentLink($id) {
	global $database, $Itemid, $my, $option, $ld, $temp;

	$rev_text = trim( mosGetParam( $_POST, 'rev_text', '' ) );
	$rev_title = trim( mosGetParam( $_POST, 'rev_title', '' ) );
	$guest_name = trim( mosGetParam( $_POST, 'guest_name', '' ) );
	
	$row = new snrLinks($database);
	$row->load($id);

	if (empty($row)) {
		mosNotAuth();
	} else {

		# User IP Address
		$vote_ip = getenv( 'REMOTE_ADDR' );

		# Check if this user has voted before
		if ( $my->id == 0 ) {
			$database->setQuery( "SELECT log_date FROM #__ldlog WHERE link_id ='".$row->id."' AND log_ip = '".$vote_ip."' AND log_type = 'comment'" );
		} else {
			$database->setQuery( "SELECT log_date FROM #__ldlog WHERE link_id ='".$row->id."' AND user_id = '".$my->id."' AND log_type = 'comment'" );
		}
		$soner = $database->loadResult();
			
		$comment = false;
		$comment = ($soner <> '') ? true : false;

		if ( $comment && $ld->writeonce == '1') {
			# This user has already comment this link
			mosRedirect( "index.php?option=com_linkdirectory&task=detail&id=$row->id&Itemid=$Itemid", _LD_ONLY_ONE_COMMENT );
		} elseif ( $ld->gaddcom == '0' && $my->id < 1 ) {
			#user login
			mosRedirect( "index.php?option=com_linkdirectory&task=detail&id=$row->id&Itemid=$Itemid", _LD_COM_ONLY_AFTER_LOGIN );
		} else {
			# OK. User is allowed to review
			$url = 'index.php?option=com_linkdirectory&amp;task=detail&amp;id='.$row->id.'&amp;Itemid='.$Itemid;
			$rateurl = 'index.php?option=com_linkdirectory&amp;task=rate&amp;id='.$row->id.'&amp;Itemid='.$Itemid;
			$commenturl = 'index.php?option=com_linkdirectory&amp;task=comment&amp;id='.$row->id.'&amp;Itemid='.$Itemid;
			$reporturl = 'index.php?option=com_linkdirectory&amp;task=report&amp;id='.$row->id.'&amp;Itemid='.$Itemid;

			if ($ld->ldisplay) {
				$row->url = $row->url;
			} else {
				$row->url = 'index.php?option=com_linkdirectory&amp;task=view&amp;id='.$row->id.'&amp;Itemid='.$Itemid;
			}

			$temp->id = $id;
			$temp->row = $row;
			$temp->catid = $row->catid;
			$temp->Itemid = $Itemid;
			$temp->option = $option;
			$temp->myid = $my->id;

			$temp->ratelink = $ld->ratelink;
			$temp->commentlink = $ld->commentlink;
			$temp->badlink = $ld->badlink;
			$temp->showfastlink = $ld->showfastlink;
			$temp->javascriptchecks = $ld->javascriptchecks;

			$temp->url = $url;
			$temp->rateurl = $rateurl;
			$temp->commenturl = $commenturl;
			$temp->reporturl = $reporturl;
			$temp->rev_text=$rev_text; 
			$temp->rev_title=$rev_title;
			$temp->guest_name=$guest_name;
			$temp->copyrigthinfo = $ld->copyrigthinfo;
			
			$temp->display('header.tpl.php');
			$temp->display('linkdetail.tpl.php');
			$temp->display('addcomment.tpl.php');
			$temp->display('footer.tpl.php');
		}
	}
}

function AddComment($id) {
	global $database, $Itemid, $my, $mosConfig_offset, $ld;

	# Get the review text
	$rev_text = trim( mosGetParam( $_POST, 'rev_text', '' ) );
	$rev_title = trim( mosGetParam( $_POST, 'rev_title', '' ) );
	$guest_name = trim( mosGetParam( $_POST, 'guest_name', '' ) );

	$link = new snrLinks($database);
	$link->load($id);

	if (empty($link)) {
		# Link does not exists, or is not published
		mosRedirect( "index.php?option=com_linkdirectory&task=detail&id=$id&Itemid=$Itemid", _LD_UNEXPECTED_ERROR );

	} elseif ( $ld->gaddcom == '0' && $my->id  < 1) {
		# User is not logged in
		mosRedirect( "index.php?option=com_linkdirectory&task=detail&id=$id&Itemid=$Itemid", _LD_LOGIN_FIRST );

	} elseif ( $rev_text == '' ) {
		# Comment text is empty
		displayError(_LD_WRITE_YOUR_COMMENT);
		CommentLink($id);
		return;
	} elseif ( $rev_title == '' ) {
		# Comment title is empty
		displayError(_LD_WRITE_YOUR_TITLE);
		CommentLink($id);
		return;
	} else {
		# User IP Address
		$vote_ip = getenv( 'REMOTE_ADDR' );

		$now = date( "Y-m-d H:i:s", time()+$mosConfig_offset*60*60 );

		# Check if this user has comment before
		if ( $my->id == 0 ) {
			$database->setQuery( "SELECT log_date FROM #__ldlog WHERE link_id ='".$id."' AND log_ip = '".$vote_ip."' AND log_type = 'comment'" );
		} else {
			$database->setQuery( "SELECT log_date FROM #__ldlog WHERE link_id ='".$id."' AND user_id = '".$my->id."' AND log_type = 'comment'" );
		}

		$soner = $database->loadResult();

		$comment = false;
		$comment = ($soner <> '') ? false : true;

		if ( $comment  && $ld->writeonce == '1' || $ld->writeonce == '0'  ) {

			# Everything is ok, add the comment
			if ($comment) {
				# Update #__ld_log table
				$database->setQuery( "INSERT INTO #__ldlog "
				.	"( `log_ip` , `log_type`, `user_id` , `log_date` , `link_id` )"
				.	"VALUES ( '$vote_ip', 'comment', '$my->id', '$now', '$id')");
				if (!$database->query()) {
					mosRedirect( "index.php?option=com_linkdirectory&task=detail&id=$id&Itemid=$Itemid",_LD_UNEXPECTED_ERROR);
				}
			}

			# Auto Publish?
			if ( $ld->autopbcomment == 1 ) {
				$rev_approved = 1;
			} else {
				$rev_approved = 0;
			}

			if ( $my->id > 0 ) {

				# User is logged on, store user ID
				$database->setQuery( "INSERT INTO #__ldcomment"
				.	"( `link_id` , `user_id` , `rev_title` , `rev_text` , `rev_date` , `rev_approved` ) "
				.	"VALUES ($id, $my->id, '$rev_title', '$rev_text', '$now', '$rev_approved')");
					
			} else {

				# User is not logged on, store Guest name
				$database->setQuery( "INSERT INTO #__ldcomment"
				.	"( `link_id` , `guest_name` , `rev_title` , `rev_text` , `rev_date` , `rev_approved` ) "
				.	"VALUES ($id, '$guest_name', '$rev_title', '$rev_text', '$now', '$rev_approved')");

			}

			if (!$database->query()) {
				mosRedirect( "index.php?option=com_linkdirectory&task=detail&id=$id&Itemid=$Itemid",_LD_UNEXPECTED_ERROR);
				return;					
			}

			if ( $ld->autopbcomment == '0' ) {
				mosRedirect( "index.php?option=com_linkdirectory&task=detail&id=$id&Itemid=$Itemid", _LD_YOUR_COMMENT_WAIT );

			} else {
				mosRedirect( "index.php?option=com_linkdirectory&task=detail&id=$id&Itemid=$Itemid", _LD_YOUR_COMMENT );
			}
		} else {
			mosRedirect( "index.php?option=com_linkdirectory&task=detail&id=$id&Itemid=$Itemid", _LD_ONLY_ONCE_C );
		}

	}
}


function LDReview(&$id, $limitstart) {
	global $database, $Itemid, $ld, $temp;

	$query = "SELECT COUNT(*) FROM #__ldcomment"
	. "\n WHERE rev_approved = 1 AND link_id = $id"
	;

	$database->setQuery($query);
	$totalcomments = $database->loadResult();
	if (($totalcomments > $ld->limitcomment) && ($ld->limitcomment > 0)) {
		require_once( _LD_ABSOLUTE_PATH . '/includes/pageNavigation.php' );
		$pageNav = new mosPageNav( $totalcomments, $limitstart, $ld->limitcomment );
	}
	else {
		$pageNav = NULL;
	}
	$query = "SELECT * FROM #__ldcomment"
	. "\n WHERE link_id = $id"
	. "\n AND rev_approved = 1"
	. "\n LIMIT $limitstart, $ld->limitcomment"
	;

	$database->setQuery( $query );
	$comments = $database->loadObjectList();

	$temp->id = $id;
	$temp->limitstart = $limitstart;
	$temp->comments = $comments;
	//$temp->option = $option;
	$temp->integration = $ld->integration;
	$temp->pageNav = $pageNav;
	$temp->display('commentlist.tpl.php');

}
?>
