<?php
/**
 * @ H2N Link Directory 1.0.0 linkdirectory.php
 * @ Copyright (C) 2008 Harry Klein - joomla.neschke.eu
 * @
 * @ Link Directory 1.1 linkdirectory.php
 * @ Copyright (C) 2006 Soner (pisdoktor) Ekici - www.sonerekici.com
 * @ All rights reserved
 * @ Link Directory Component is Free Software
 * @ Released under GNU/GPL License : http://www.gnu.org/copyleft/gpl.html
 **/

defined( '_VALID_MOS' ) or die( 'Restricted access' );

$path = preg_replace("!(\\\)!i","/",dirname(__FILE__));
define('_LD_ABSOLUTE_PATH', str_replace("/components/com_linkdirectory","",$path));
define('_LD_FRONTEND_PATH', $path );
define('_LD_BACKEND_PATH',_LD_ABSOLUTE_PATH . '/administrator/components/com_linkdirectory');

require_once( $mainframe->getPath( 'class' ) );



if (file_exists(_LD_BACKEND_PATH.'/language/'.$mainframe->getCfg('lang').'.php')){
	include(_LD_BACKEND_PATH.'/language/'.$mainframe->getCfg('lang').'.php');
}else{
	include(_LD_BACKEND_PATH.'/language/english.php');
}

//include config file
if (!file_exists(_LD_BACKEND_PATH.'/config.php')){
	echo "Config File Not Found";
	die();
} else {
	include(_LD_BACKEND_PATH.'/config.php');
}

//load required files
include(_LD_FRONTEND_PATH .'/linkdirectory.categories.php');
include(_LD_FRONTEND_PATH .'/linkdirectory.links.php');
include(_LD_FRONTEND_PATH .'/linkdirectory.tools.php');
include(_LD_FRONTEND_PATH .'/linkdirectory.comments.php');
include(_LD_FRONTEND_PATH .'/linkdirectory.rating.php');
include(_LD_FRONTEND_PATH .'/linkdirectory.search.php');
include(_LD_FRONTEND_PATH .'/linkdirectory.badlink.php');
include(_LD_FRONTEND_PATH .'/linkdirectory.aco.php');
include(_LD_FRONTEND_PATH .'/linkdirectory.captcha.php');
include(_LD_FRONTEND_PATH .'/savant/Savant3.php');

//Load Savant3
global $temp;
$temp = new Savant3();

$temp->addPath('template', _LD_FRONTEND_PATH.'/templates/'.$ld->template);
$temp->addPath('resource', _LD_FRONTEND_PATH.'/savant/Savant3/');

//get some variable
$id 	= intval( mosGetParam( $_REQUEST, 'id', 0 ) );
$catid 	= intval( mosGetParam( $_REQUEST, 'catid', 0 ) );
$limitstart = intval( mosGetParam( $_REQUEST, 'limitstart', 0 ) );

//Cache activation
$cache =& mosCache::getCache( 'com_linkdirectory' );
//Init Globals
global $Itemid, $my;

//let's go ;)
switch ($task) {
	//Default homepage of the component
	default:
		IncludeCSS();
		$cache->call('Categories', $option, $Itemid);
		break;
		//View categories
	case 'viewcat':
		IncludeCSS();
		$cache->call('ViewCategory', $catid, $option, $Itemid, $limitstart);
		break;
		//View detailed info for selected link
	case 'detail':
		IncludeCSS();
		$cache->call('DetailLink', $id, $option, $Itemid, $limitstart);
		break;

	case 'view':
		IncludeCSS();
		$cache->call('ViewLink', $id);
		break;

		//Search in to the component
	case 'search':
		$searchtext = mosGetParam( $_REQUEST, 'searchtext','');
		if ($ld->sengine) {
			IncludeCSS();
			$cache->call('Search', $searchtext, $catid, $option);
		} else {
			mosNotAuth();
		}
		break;

	case 'advsearch':
		IncludeCSS();
		$cache->call('AdvancedSearch', $catid, $option);
		break;

	case 'sresult':
		IncludeCSS();
		$cache->call('SearchResult');

		//Add a link
	case 'new':
		if ($ld->userid >= $ld->allowadd) {
			IncludeCSS();
			$cache->call('editLink', 0, $option, $catid, $Itemid);
		} else {
			mosRedirect('index.php?option=com_linkdirectory&amp;Itemid='.$Itemid,_LD_CANT_ADD_WEB_LINK);
		}
		break;

		//Edit a link
	case 'edit':
		if ($ld->userid >= $ld->allowedit) {
			IncludeCSS();
			$cache->call('editLink', $id, $option, $catid, $Itemid);
		} else {
			mosRedirect('index.php?option=com_linkdirectory&amp;Itemid='.$Itemid,_LD_CANT_EDIT_WEB_LINK);
		}
		break;

		//Save a link
	case 'save':
		IncludeCSS();
		$cache->call('SaveLink', $id, $option, $catid, $Itemid);
		break;

		//Rate link
	case 'rate':
		if ($ld->ratelink) {
			IncludeCSS();
			$cache->call('RateLink', $id, $option);
		}
		break;

		//Add rating
	case 'addrate':
		if ($ld->ratelink) {
			IncludeCSS();
			$cache->call('AddRate', $id, $option);
		}
		break;

		//Comment link
	case 'comment':
		if ($ld->commentlink) {
			IncludeCSS();
			$cache->call('CommentLink', $id, $option);
		}
		break;

		//Add comment
	case 'addcomment':
		if ($ld->commentlink) {
			IncludeCSS();
			$cache->call('AddComment', $id, $option);
		}
		break;

		//Report a link
	case 'report':
		if ($ld->badlink) {
			IncludeCSS();
			$cache->call('ReportLink', $id, $option);
		} else {
			mosNotAuth();
		}
		break;

		//Send report mail
	case 'sendreport':
		if ($ld->badlink) {
			$cache->call('SendReport', $id, $option);
		} else {
			mosNotAuth();
		}
		break;

		//Suggest a cat
	case 'suggestcat':
		if ($ld->scat) {
			IncludeCSS();
			$cache->call('SuggestCat', $catid);
		} else {
			mosNotAuth();
		}
		break;

		//Add suggested category to db
	case 'addcat':
		if ($ld->scat) {
			IncludeCSS();
			$cache->call('AddSCat');
		} else {
			mosNotAuth();
		}
		break;
}
?>