<?php
/**
 * @ H2N Link Directory 1.0.0 linkdirectory.tools.php
 * @ Copyright (C) 2008 Harry Klein - joomla.neschke.eu
 * @
 * @ Link Directory 1.1 linkdirectory.tools.php
 * @ Copyright (C) 2006 Soner (pisdoktor) Ekici - www.sonerekici.com
 * @ All rights reserved
 * @ Link Directory Component is Free Software
 * @ Released under GNU/GPL License : http://www.gnu.org/copyleft/gpl.html
 * @
 * @ $Id: linkdirectory.tools.php,v 1.14 2008/05/22 19:55:47 harry Exp $
 * @
 **/

defined( '_VALID_MOS' ) or die( 'Restricted access' );

//This function include component css file if selected...
function IncludeCSS() {
	global $ld, $mainframe, $mosConfig_live_site;

	$mainframe->addCustomHeadTag("<link href='$mosConfig_live_site/components/com_linkdirectory/templates/$ld->template/css/linkdirectory.css' rel='stylesheet' type='text/css' />");
}

//Link Directory Pathway - Orginal Code => Pony Gallery (Thanks Danial (danialt) Taherzadeh)
function LDPathway( $catid ) {
	global $database, $gid, $Itemid;

	$catid=intval( $catid );
	$parent_id=1000;
	
	while ( $parent_id && ($catid != 0) ) {
		$query="SELECT * FROM #__ldcats WHERE id=$catid AND published=1"
		. "\n AND access<='" . $gid . "'";

		$database->setQuery( $query );
		$rows=$database->loadObjectList();
		if ( $rows == null) return '';
		$row=$rows[0];
		if ( $row == null) return '';
		$parent_id=$row->parent_id;
		$id=$row->id;

		$name="<a class='ldpathway' href='" . sefRelToAbs("index.php?option=com_linkdirectory&amp;task=viewcat&amp;catid=$catid&amp;Itemid=$Itemid" )."'>" . $row->name . "</a>";

		// write path
		if ( empty( $path ) ) {
			$path=$name;
		} else {
			$path=$name . ' - ' . $path;
		}
		// next looping
		$catid=$parent_id;
	}

	$home="<a class='ldpathway' href='" . sefRelToAbs( "index.php?option=com_linkdirectory&amp;Itemid=$Itemid" ) . "'>". _LD_HOME ."</a>";
	
	if ( empty( $path ) ) {
		$pathName=$home . " ";		  
	} else {
		$pathName=$home . ' - ' . $path . " ";
	}
	return $pathName;

}

//Set categories hierarchically...
function categoryArray() {
	global $database, $my;
	 
	// get a list of the menu items
	$query = "SELECT c.*, c.parent_id AS parent"
	. "\n FROM #__ldcats c"
	. "\n WHERE published <> -2 AND access <= '$my->gid'"
	. "\n ORDER BY ordering" ;
	 
	$database->setQuery($query);
	$items = $database->loadObjectList();
	// establish the hierarchy of the menu
	$children = array();
	// first pass - collect children
	foreach ($items as $v) {
		$pt = $v->parent;
		$list = @$children[$pt] ? $children[$pt] : array();
		array_push($list, $v);
		$children[$pt] = $list;
	}
	// second pass - get an indent list of the items
	$array = mosTreeRecurse(0, '', array(), $children);

	return $array;
}

//List categories
function ComponentCategory( $name, $active=NULL, $javascript=NULL, $order='ordering', $size=1, $sel_cat=1 ) {
	global $database;

	$list = categoryArray();

	$options[] = mosHTML::makeOption('', _SEL_CATEGORY);
	// assemble menu items to the array
	foreach ($list as $item) {
		$options[] = mosHTML::makeOption($item->id, $item->treename);
	}

	$category = mosHTML::selectList( $options, $name, 'class="inputbox" size="'. $size .'" '. $javascript, 'value', 'text', $active );

	return $category;
}

//Add web link
function AddPanel(&$catid, $Itemid) {
	global $ld, $Itemid;

	$catid = intval(mosGetParam($_GET, 'catid', 0));

	if (!$catid) {
		$link = sefReltoAbs('index.php?option=com_linkdirectory&amp;task=new&amp;Itemid='.$Itemid);
	} else {
		$link = sefReltoAbs('index.php?option=com_linkdirectory&amp;task=new&amp;catid='.$catid.'&amp;Itemid='.$Itemid);
	}

	if ($ld->userid >= $ld->allowadd) {
		?>
<td class="addlink"><a class="addlink" href="<?php echo $link;?>"><?php echo _LD_ADDLINK;?></a>
</td>
		<?php
}
}

//Edit a web link
function EditPanel(&$id, $Itemid) {
	global $ld, $database, $Itemid;

	$id = intval(mosGetParam($_GET, 'id', 0));

	$row = new snrLinks($database);
	$row->load($id);

	$link = sefRelToAbs('index.php?option=com_linkdirectory&amp;task=edit&amp;id='.$row->id.'&amp;catid='.$row->catid.'&amp;Itemid='.$Itemid);

	if ($ld->userid >= $ld->allowedit) {
		?>
<a class="editlink" href="<?php echo $link;?>"><?php echo _LD_EDITLINK;?></a>
		<?php
}
}

//Search in to the component
function SearchForm(&$catid, $Itemid) {
	global $ld, $Itemid;

	$catid = intval(mosGetParam($_GET, 'catid', 0));
	if ($ld->sengine) {
		if ($catid) {
			$advlink = sefReltoAbs('index.php?option=com_linkdirectory&amp;task=advsearch&amp;catid='.$catid.'&amp;Itemid='.$Itemid);
		} else {
			$advlink = sefReltoAbs('index.php?option=com_linkdirectory&amp;task=advsearch&amp;Itemid='.$Itemid);
		}
		?>
<td>
<form action="index.php" method="get"><input type="hidden" name="option"
	value="com_linkdirectory" /> <input type="hidden" name="task"
	value="search" /> <?php if ($catid) {?> <input type="hidden"
	name="catid" value="<?php echo $catid;?>" /> <?php } ?> <?php echo _LD_SRCH;?>:<input
	name="searchtext" type="text" size="15" class="inputbox" />&nbsp;<?php if ($ld->advsearch) {?><a
	href="<?php echo $advlink;?>"><?php echo _LD_ADV_SEARCH;?></a><?php } ?>
<input type="hidden" name="Itemid" value="<?php echo $Itemid;?>" /></form>
</td>
		<?php
}
}

//Return total link selected category
function TotalLink(&$id) {
	global $database;

	$query = "SELECT count(*) FROM #__ldlinks"
	. "\n WHERE catid = $id"
	. "\n AND published = 1"
	;

	$database->setQuery($query);
	$totallink = $database->loadResult();

	echo $totallink;
}

//Return total subcategory selected category
function TotalSubCat(&$id) {
	global $database, $my;

	$query = "SELECT count(*) FROM #__ldcats"
	. "\n WHERE parent_id = $id"
	. "\n AND published = 1"
	. "\n AND access <= $my->gid"
	;

	$database->setQuery($query);
	$totalsubcat = $database->loadResult();
	echo $totalsubcat;
}

//Return total comment selected link
function TotalComment(&$id) {
	global $database;

	$query = "SELECT count(*) FROM #__ldcomment"
	. "\n WHERE link_id = $id"
	. "\n AND rev_approved = 1"
	;

	$database->setQuery($query);
	$totalcomment = $database->loadResult();

	echo $totalcomment;
}

//Suggestion function if set yes ;)
function SuggestCat($catid, $active=NULL, $javascript=NULL, $size=1, $sel_cat=1) {
	global $Itemid, $temp, $ld;

	$catid = intval(mosGetParam($_REQUEST, 'catid', 0));
	$list = categoryArray();

	$options[] = mosHTML::makeOption('0', '- '._LD_ROOT.' -');
	// assemble menu items to the array
	foreach ($list as $item) {
		$options[] = mosHTML::makeOption($item->id, $item->treename);
	}
	
	$parent_id = intval(mosGetParam($_POST, 'parent_id', $catid));
	$list = mosHTML::selectList( $options, 'parent_id', 'class="inputbox" size="'. $size .'" '. $javascript, 'value', 'text', $parent_id );

	$temp->catid = $catid;
	$temp->Itemid = $Itemid;
	$temp->parent = $list;
	$temp->title = mosGetParam($_POST, 'title', '');
	$temp->name = mosGetParam($_POST, 'name', '');
	$temp->description = mosGetParam($_POST, 'description', '');
	$temp->copyrigthinfo = $ld->copyrigthinfo;
	
	$temp->display('header.tpl.php');
	$temp->display('suggest.tpl.php');
	$temp->display('footer.tpl.php');

	//Suggest_HTML::Suggest($lists, $Itemid);
}

//Add suggested category to db
function AddSCat() {
	global $database, $Itemid;

	global $database;

	$row = new snrCats( $database );
	if (!$row->bind( $_POST )) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}
	if (!$row->check()) {
		displayError($row->getError());
		SuggestCat(0);
		return ;
	}

	if (!$row->store()) {
		displayError($row->getError());
		SuggestCat(0);
		return ;
	}
	$row->checkin();


	if (!$database->query()) {
		displayError($row->getError());
		SuggestCat(0);
		return ;
	}

	mosRedirect('index.php?option=com_linkdirectory&amp;Itemid'.$Itemid, _LD_CATSUG_SEND );

}

function displayError($msg){
	echo '<div class="message">'.$msg.'</div>';
}

function displayText4Javascript($text=''){
	$table=get_html_translation_table(HTML_ENTITIES);
	$rev_trans = array_flip($table);
	echo strtr($text,$rev_trans);
}
?>
